#ifndef CaloStruct_h
#define CaloStruct_h

struct cCaloLevel2 {
  
  Int_t calntrk;    
  Int_t caltrkseqno[11];  
  Int_t ncore[11];     
  Int_t noint[11];     
  Int_t ncyl[11];      
  Int_t nlast[11];     
  Int_t npre[11];      
  Int_t npresh[11];    
  Int_t ntr[11];       
  Int_t planetot[11];  
  Int_t nlow[11];      
  Float_t qcore[11];   
  Float_t qcyl[11];    
  Float_t qlast[11];   
  Float_t qpre[11];    
  Float_t qpresh[11];  
  Float_t qtr[11];     
  Float_t qtrack[11];  
  Float_t qtrackx[11]; 
  Float_t qtracky[11]; 
  Float_t dxtrack[11]; 
  Float_t dytrack[11]; 
  Float_t qmean[11];   
  Float_t qlow[11];    
  Float_t dX0l[11];    
  Float_t tbar[11][22][2];    
    
    
  Int_t good;      
  Int_t perr[4];   
  Int_t swerr[4];  
  Int_t calcrc[4];    
  Int_t selftrigger;
    
  Int_t nstrip;     
  Int_t nx22;       
  Int_t planemax[2];
  Float_t qtot;     
  Float_t qx22;     
  Float_t qmax;     
  Float_t qq[4];    
    
  Int_t npcfit[2];  
  Float_t impx;     
  Float_t impy;     
  Float_t tanx;     
  Float_t tany;         
  Float_t varcfit[2];
    
  Float_t elen;      
  Float_t selen;     
  

  void InitcCaloLevel2(){

    calntrk = 0;
    good = 0; 
    selftrigger = 0;
    nstrip = 0;     
    nx22 = 0;   
    qtot = 0;     
    qx22 = 0;     
    qmax = 0;    
    impx = 0;     
    impy = 0;     
    tanx = 0;     
    tany = 0;  
    elen = 0;      
    selen = 0;     
    memset(tbar, 0, 11*2*22*sizeof(Float_t));
    for(Int_t i=0;i<11;i++){
      caltrkseqno[i] = 0;  
      ncore[i] = 0;     
      noint[i] = 0;     
      ncyl[i] = 0;      
      nlast[i] = 0;     
      npre[i] = 0;      
      npresh[i] = 0;    
      ntr[i] = 0;       
      planetot[i] = 0;  
      nlow[i] = 0;      
      qcore[i] = 0;   
      qcyl[i] = 0;    
      qlast[i] = 0;   
      qpre[i] = 0;    
      qpresh[i] = 0;  
      qtr[i] = 0;     
      qtrack[i] = 0;  
      qtrackx[i] = 0; 
      qtracky[i] = 0; 
      dxtrack[i] = 0; 
      dytrack[i] = 0; 
      qmean[i] = 0;   
      qlow[i] = 0;    
      dX0l[i] = 0;    
    }
    for(Int_t i=0;i<4;i++){
      perr[i] = 0;   
      swerr[i] = 0;  
      calcrc[i] = 0;    
      qq[i] = 0;    
    }
    for(Int_t i=0;i<2;i++){    
      planemax[i] = 0;
      npcfit[i] = 0;        
      varcfit[i] = 0;
    }
  }
};

#endif
