      SUBROUTINE NUCLEI(RPIANO,NPIANI,QQQQ,NTOT,INDICE)
C----------------------------------------------------------------------
C-
C-   Purpose and Methods : IT FINDS THE NUMBER OF LAYERS (RPIANO) IN WHICH
C-   THERE IS A DETECTED ENERGY BETWEEN EINF AND ESUP . FOR EXAMPLE IF
C-   EINF = 2.5 mip AND ESUP = 10 mip WE INDENTIFY PARTICLE WITH A
C-   CHARACTERISTIC AS ALPHA AT MINIMUM .
C-   QQQQ IS THE TRUNCATED MEAN OF THE DETECTED ENERGY OF THE BARICENTRA OF THE
C-   DEFINED LAYERS .
C-   NTOT GIVES THE NUMBER OF LAYERS WITH DETECTED ENERGY ALONG THE TRACK
C-   DEFINED BY THE TRACKING SYSTEM . WE SAY THAT IS ALONG THE TRACK IF THE
C-   CLUSTER IS INSIDE A RADIUS OF 4 STRIPS BY THE POSITION DEFINED BY THE
C-   TRACKING SYSTEM .
C-   INDICE IS THE NUMBER OF CLUSTERS BESIDES THAT ALONG THE TRACK THAT ARE
C-   MORE THAN 4 STRIPS FAR AWAY BY THE TRACK .
C-
C-   Inputs  : NPIANI
C-   Outputs : RPIANO,QQQQ,NTOT,INDICE
C-   Controls:
C-
C-   Created   9-FEB-1994   MIRKO BOEZIO
C-   Modified 28-APR-1994   MIRKO BOEZIO . IF ISTRISCIA IS NEGATIVE AND GREATER
C-   THAN NX THAN NN IS EQUAL 1 .
C-   Modified  8-JUL-1994   MIRKO BOEZIO . CORRECTED AN ERROR ON THE DEFINITION
C-   OF ISTRISCIA .
C-   Modified  14-DEC-1994   MIRKO BOEZIO . THE TRACK IS DEFINED BY THE
C-   TRACKING SYSTEM THROUGH IBAR AND BAR .
C-
C----------------------------------------------------------------------
      INCLUDE 'INTEST.TXT'
C
      REAL LUNGH
      REAL RPIANO(2)
      REAL BAR(2,NPLAV)
      REAL NQQ(2*NPLAV)
      REAL RIL(NCHA/2)
      REAL REL(NCHA/2)
      REAL TG(2)
      INTEGER IBAR(2,NPLAV)
      INTEGER NTOT(2),LH
      COMMON / ANGOLO / BAR, IBAR
      SAVE / ANGOLO /
      COMMON / DOVE / NX, NY, LUNGH
      SAVE / DOVE /
      COMMON / TAGLIOEN / EINF, ESUP, ENER(2)
      SAVE / TAGLIOEN /
      COMMON / SHIFT / SHIFT
      SAVE / SHIFT /
      COMMON / TANGENTI / TG
      SAVE / TANGENTI /
C
      RINDEX = 0.
C
      DO K = 1,NCHA/2
        RIL(K) = 1000.
      ENDDO
C
      ENER(1) = 0.
      ENER(2) = 0.
C
      QQQ = 0.
      QQQQ = 0.
      QQX = 0.
      QQY = 0.
      NGIR = 0
      DO M = 1,2
        NTOT(M) = 0
        RPIANO(M) = 0.
C
        DO J = 1,NPLA
C
           IF (MOD(J,2).EQ.0) THEN
              IF (REVERSE.EQ.0) THEN
                 SHIFT = -0.5
              ELSE
                 SHIFT = +0.5
              ENDIF
           ELSE
              IF (REVERSE.EQ.0) THEN
                 SHIFT = +0.5
              ELSE
                 SHIFT = -0.5
              ENDIF
           ENDIF
C
          DO K = 1,NGIR
            RIL(K) = 1000.
          ENDDO
C
          IF (M.EQ.1) NQQ(J) = 0.
          IF (M.EQ.2) NQQ(J+NPLA) = 0.
          NNN = 0
C
          NN = IBAR(M,J)
C          
C     EM
C
          IF (NN.EQ.-1) GOTO 5
C
          IF (NN.LE.0) NN = 1
          NGIR = NCL(M,J) ! number of clusters in layer J of the M View
          IF (NGIR.EQ.0) GOTO 5
C          IF (NGIR.NE.1) GOTO 5
          IPP = 0.
          DO L = 1,NGIR
            CALL LASTRISCIA(CLUS(M,J,L),IN)
            RIL(L) = FLOAT(ABS(NN - IN))
            REL(L) = CLUS(M,J,L+NCHA/2)
            IF (RIL(L).GE.5) IPP = 1
          ENDDO
          MM = NCHA/2
C
C WE USE THE CLUSTER NEAREST THE TRACK .
C
c          LK = LVMIN(RIL,MM)
          LH = LVMAX(REL,MM)
C
C CHECK ON THE DISTANCE OF THE CLUSTER FROM THE TRACK .
C
C          IF (RIL(LK).GE.5) GOTO 5
          IF (RIL(LH).GE.10) GOTO 5
          IF (IPP.EQ.1) INDICE = INDICE + 1
          IF (J.EQ.1) ENER(M) = CLUS(M,J,LH+NCHA/2) ! this is the detected
C                                 energy of the cluster in the first layer
C
          NTOT(M) = NTOT(M) + 1
C
C CHECK ON THE DETECTED ENERGY OF THE CLUSTER .
C
          IF (CLUS(M,J,LH+NCHA/2).GT.EINF.AND.CLUS(M,J,LH+NCHA/2).
     &      LT.ESUP) THEN
            IADD = 0
            IF (M.EQ.2) IADD = NPLA
            NQQ(J + IADD) = NQQ(J + IADD) + CLUS(M,J,LH+NCHA/2)
            NNN = NNN + 1
          ENDIF
C
    5     CONTINUE
          IADD = 0
          IF (M.EQ.2) IADD = NPLA
          IF (NQQ(J + IADD).LT.EMIN) NQQ(J + IADD) = 10000.
          IF (NNN.GE.1) RPIANO(M) = RPIANO(M) + 1
C
        ENDDO
      ENDDO
C
      RPIATOT = RPIANO(1) + RPIANO(2)
C
      IF (RPIATOT.GE.FLOAT(NPIANI)) THEN
        NPIA = NPIANI
      ELSE
        NPIA = INT(ANINT(RPIATOT))
      ENDIF
C
      QQQ = 0.
C
      NDIM = 2 * NPLA
C
      DO I = 1,NPIA
        N = LVMIN(NQQ,NDIM)
        QQQ = QQQ + NQQ(N)
        NQQ(N) = 10000.
      ENDDO
C
      IF (NPIA.NE.0) THEN
        QQQQ = QQQ / FLOAT(NPIA)  ! Truncated mean .
      ENDIF
C
c  400 CONTINUE
      CONTINUE

      RETURN
      END
C

