      SUBROUTINE DIRECTION(DEVIA)
C-----------------------------------------------------
C-
C-   Purpose and Methods : PROGRAM THAT DETERMINES THE
C-   TRACK PROJECTIONS ON THE PLANE XZ AND YZ USING
C-   ONLY CALORIMETER INFORMATION .
C-
C-   Inputs  :
C-   Outputs :
C-   Controls:
C-
C-   Created   9-FEB-1994   MIRKO BOEZIO
C-   Modified  21-FEB-2003   MIRKO BOEZIO . ADAPTED TO
C-   BE USED FOR PAMELA CALORIMETER .
C-
C------------------------------------------------------

      IMPLICIT NONE

      INCLUDE 'INTEST.TXT'

      REAL FLIMIT, FLIMIT2
      INTEGER NVAR,NPAR
      PARAMETER (NVAR=1,NPAR=2)          
c      PARAMETER (FLIMIT=10000)
c      PARAMETER (FLIMIT2=2000)
c      PARAMETER (FLIMIT=500)
      PARAMETER (FLIMIT=2000)
      PARAMETER (FLIMIT2=500)
      REAL X(NPLAV),Y(NPLAV),W(NPLAV)
      REAL DEVIA(2),TG(2)
      REAL BAR(2,NPLAV)
      REAL A, B, VAR
      REAL SA, SB, SVAR
      REAL SSA, SSB, SSVAR
      REAL PIANO(NPLAV)
      REAL VARFIT(2)

      INTEGER ICONT, M, I, SNPFIT,SSNPFIT
      INTEGER NPFIT(2), CHTRACK,IWPL(2)
      INTEGER FORCEMODE
      
      INTEGER IBAR(2,NPLAV)      
      COMMON/ANGOLO/BAR,IBAR
      SAVE /ANGOLO/

      REAL CX, CY
      COMMON/WHERE/CX,CY,PIANO
      SAVE /WHERE/

      COMMON/CALOFIT/VARFIT,NPFIT,IWPL,CHTRACK
      SAVE/CALOFIT/
C
      ICONT = 0
      DEVIA(1) = 0.
      DEVIA(2) = 0.
      CX = 0.
      CY = 0.
C
      NPFIT(1) = NPLA
      NPFIT(2) = NPLA
      VARFIT(1) = 0.
      VARFIT(2) = 0.      
C
      FORCEMODE = -1
      IF (FMODE(1).GE.1000.AND.FMODE(2).GE.1000) THEN
         FORCEMODE = FMODE(1)-1000
      ENDIF         
C
C THE FIT IS PERFORMED WHEN THERE ARE AT LEAST TWO 
C LAYERS WITH SIGNAL . FOR THE FIT THE CLUSTER WITH THE
C HIGHEST DETECTED ENERGY IS USED . 
C
      DO M = 1,2
         SA = 0
         SB = 0
         SVAR = 0
         FMODE(M) = 0
 10      CONTINUE         
         ICONT = 0
         CALL VZERO(X,NPLAV)
         CALL VZERO(Y,NPLAV)
         CALL VZERO(W,NPLAV)
         DO I = 1,NPLA
C    
            IF (MOD(M,2).EQ.0) THEN
               X(I) = PIANO(I)
C               X(I) = PIANO(I) - 5.81
            ELSE
               X(I) = PIANO(I) - 5.81
C               X(I) = PIANO(I)                  
            ENDIF
            Y(I) = 0.
C
C
C
            IF ((FMODE(M).EQ.0.AND.FORCEMODE.EQ.-1)
     +           .OR.FORCEMODE.EQ.0) THEN
               IF (NCL(M,I).GE.1) THEN
                  ICONT = ICONT + 1
                  Y(I) = CLUS(M,I,1)
                  W(I) = ((CLUS(M,I,1+NCHA/2)**0.79))**2.
                  IF (W(I).GT.2000.) THEN
                     W(I) = 2000.
C                     Y(I) = 0. 
C                     ICONT = ICONT -1
                  ENDIF
               ENDIF
            ENDIF
C
C No weigth and less cluster per plane
C
            IF((FMODE(M).EQ.1.AND.FORCEMODE.EQ.-1).OR.
     +           FORCEMODE.EQ.1) THEN
               IF (NCL(M,I).GE.1.AND.NCL(M,I).LE.2) THEN
                  ICONT = ICONT + 1
                  Y(I) = CLUS(M,I,1)
                  W(I) = ((CLUS(M,I,1+NCHA/2)**0.29))**2.
c                  W(I) = 1.
               ENDIF
c               IF (W(I).GT.2000.) THEN
cx                  W(I) = 2000.
cc                  Y(I) = 0. 
cc                  ICONT = ICONT -1
c               ENDIF
            ENDIF
c
c One cluster per plane
c
            IF((FMODE(M).EQ.2.AND.FORCEMODE.EQ.-1).OR.
     +           FORCEMODE.EQ.2) THEN
               IF (NCL(M,I).EQ.1) THEN
                  ICONT = ICONT + 1
                  Y(I) = CLUS(M,I,1)
                  W(I) = ((CLUS(M,I,1+NCHA/2)**0.79))**2.
c                  W(I) = 1.
               ENDIF
            ENDIF
c            if (Y(I).eq.0.or.W(I).eq.2000.) NPFIT(M) = NPFIT(M) - 1
            if (Y(I).eq.0.) NPFIT(M) = NPFIT(M) - 1
         ENDDO
C     
         
         A = 0.
         B = 0.
         VAR = 0.
c         print *,' icont = ',icont
         IF (ICONT.GE.2) THEN
            CALL LFITW(X,Y,W,NPLA,0,A,B,VAR)
         ELSE
            NPFIT(M) = 0
         ENDIF
C
         IF (FORCEMODE.EQ.-1) THEN
C     
C     TRY A BETTER FIT IF VAR IS BIG ON THE FIRST TRY
C     
            IF ((ABS(VAR).GT.FLIMIT.OR.VAR.EQ.0.)
     &           .AND.FMODE(M).EQ.0) THEN
               SVAR = VAR
               SB = B
               SA = A
               SNPFIT = NPFIT(M)
               NPFIT(M) = NPLA
               FMODE(M) = 1
               GOTO 10
            ENDIF
C     
C     TRY AGAIN IF STILL BAD AND WE HAVE AT LEAST 10 POINT TO MAKE THE FIT
C     
            IF ((ABS(VAR).GT.FLIMIT2.OR.VAR.EQ.0.).AND.FMODE(M).EQ.1
     &           .AND.SNPFIT.GT.5) THEN
               SSVAR = VAR
               SSB = B
               SSA = A
               SSNPFIT = NPFIT(M)
               NPFIT(M) = NPLA
               FMODE(M) = 2
               GOTO 10
            ENDIF          
C     
C     IF WE ARE AT THE THIRD TRY AND THE FIT IS WORST THAN THE SECOND TRY TAKE THE FIRST TRY
C     
            IF (FMODE(M).EQ.2) THEN
               IF (ABS(VAR).GT.ABS(SSVAR).OR.ABS(VAR).EQ.0.
     &              .OR.NPFIT(M).LE.4) THEN
                  FMODE(M) = 1
                  VAR=SSVAR
                  B = SSB
                  A = SSA
                  NPFIT(M) = SSNPFIT
               ENDIF
            ENDIF
C     
C     IF THE SECOND TRY AND THE FIT IS WORST THAN THE FIRST TRY TAKE THE FIRST TRY
C     
            IF (FMODE(M).EQ.1) THEN
               IF (ABS(VAR).GT.ABS(SVAR).OR.ABS(VAR).EQ.0.) THEN
                  FMODE(M) = 0
                  VAR=SVAR
                  B = SB
                  A = SA
                  NPFIT(M) = SNPFIT
               ENDIF
            ENDIF
         ENDIF
C
         VARFIT(M) = VAR
         IF (M.EQ.1) CX = B
         IF (M.EQ.2) CY = B
         DEVIA(M) = A
         TG(M) = A
C
      ENDDO
C

c  500 CONTINUE
      CONTINUE
      RETURN
      END
