#ifndef l2calcore_h
#define l2calcore_h
#include <TSystem.h>
#include <TSQLServer.h>
#include <GLTables.h>

/* trigger configuration */
#define CTOF1     (1<<0) // (S11 + S12) * (S21 + S22) * (S31 + S32)
#define CTOF2     (1<<1) // (S11 * S12) * (S21 * S22) * (S31 * S32)
#define CTOF3     (1<<2) // (S21 + S22) * (S31 + S32)
#define CTOF4     (1<<3) // (S21 * S22) * (S31 * S32)
#define CTOF5     (1<<4) // S12 * (S21 * S22)
#define CTOF6     (1<<5) // (S11 + S12) * (S31 + S32)
#define CTOF7     (1<<6) // (S11 * S12) * (S31 * S32)
#define CS4       (1<<7) // S4_1
#define CCALO     (1<<8) // CALO_1 + CALO_2 + CALO_3 + CALO_4
#define CCALIB_ON (1<<9)

/* Pattern Trigger definitions */
#define PT_LENGTH 6

/* PT: scintillators */
#define S11(pt) (pt[5] != 0)
#define S12(pt) (pt[4] != 0)
#define S21(pt) ((pt[3] & 0x00F) != 0)
#define S22(pt) ((pt[3] & 0x0F0) != 0)
#define S31(pt) ((pt[2] & 0x03F) != 0)
#define S32(pt) ((pt[2] & 0xFC0) != 0)

/* PT: calorimeter */
#define PCaloST(pt)         (pt[0] & 0x0F)
#define PCalo(pt)           ((pt[0] & 0x0F) != 0)
#define PCaloSection(pt, s) ((pt[0] & (1<<s)) != 0)
#define PCaloXE(pt)         ((pt[0] & 0x04) != 0)
#define PCaloXO(pt)         ((pt[0] & 0x08) != 0)
#define PCaloYE(pt)         ((pt[0] & 0x01) != 0)
#define PCaloYO(pt)         ((pt[0] & 0x02) != 0)

/* PT: S4 */
#define PS4(pt) ((pt[1] & 0x01) != 0)

struct FlCaLevel1 {
    Double_t al_p[5][2];
    Float_t estrip[96][22][2];
    Int_t good2;
    Int_t trkchi2;
    Float_t xalig;
    Float_t yalig;
    Float_t zalig;
    Float_t emin;
    Float_t riginput;
    Int_t hzn;
    Int_t npla;
    Int_t reverse;
};

struct FlCaLevel2 {
    Int_t fmode[2];
    Float_t wartrig;
    Float_t trigty;
    Int_t good;
    Int_t perr[4];
    Int_t swerr[4];
    Int_t crc[4];
    Int_t selftrigger;
    Float_t nstrip;
    Float_t nsatstrip;
    Float_t qtot;
    Float_t ncore;
    Float_t qcore;
    Float_t impx;
    Float_t impy;
    Float_t tanx;
    Float_t tany;
    Float_t noint;
    Float_t ncyl;
    Float_t qcyl;
    Float_t qtrack;
    Float_t qmax;
    Float_t nx22;
    Float_t qx22;
    Float_t qq[4];
    Float_t qtrackx;
    Float_t qtracky;
    Float_t dxtrack;
    Float_t dytrack;
    Float_t qlast;
    Float_t nlast;
    Float_t qpre;
    Float_t npre;
    Float_t qpresh;
    Float_t npresh;
    Float_t qlow;
    Float_t nlow;
    Float_t qtr;
    Float_t ntr;
    Float_t planetot;
    Float_t qmean;
    Int_t planemax[2];
    Float_t dX0l;
    Float_t varcfit[2];
    Int_t npcfit[2];
    Int_t cibar[22][2];
    Int_t tibar[22][2];
    Float_t cbar[22][2];
    Float_t tbar[22][2];
    Float_t elen;
    Float_t selen;
    Int_t selfdelay[4][7];
};

/* struct FlEventi{ */
/*     Float_t dexy[96][22][2]; */
/* }; */

/* struct FlGruppo{ */
/*     Float_t clus[96][22][2]; */
/*     Int_t ncl[22][2]; */
/* }; */

/* struct FlGruppo2{ */
/*     Float_t clus2[96][22][2]; */
/*     Int_t ncl2[22][2]; */
/* }; */

/* struct FlGruppo4{ */
/*     Float_t clus4[96][22][2]; */
/*     Int_t ncl4[22][2]; */
/* }; */

/* struct FlTaglioen{ */
/*     Float_t einf; */
/*     Float_t esup; */
/*     Float_t ener[2]; */
/* }; */

/* struct FlAngolo{ */
/*     Float_t bar[22][2]; */
/*     Int_t ibar[22][2]; */
/* }; */

/* struct FlWhere{ */
/*     Float_t cx; */
/*     Float_t cy; */
/*     Float_t piano[22]; */
/* }; */

/* struct FlGeneral{ */
/*     Float_t rig; */
/*     Float_t rmass; */
/* }; */

/* struct FlCh{ */
/*     Float_t check; */
/* }; */

/* struct FlCalofit{ */
/*     Float_t varfit[2]; */
/*     Int_t npfit[2]; */
/*     Int_t iwpl[2]; */
/*     Int_t chtrack; */
/* }; */

/* struct FlPawcd{ */
/*     Float_t hmemor[9000000]; */
/* }; */

/* struct FlQuestd{ */
/*     Int_t iquest[100]; */
/* }; */

extern int CaloCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t calargc, char *calargv[]);

#endif
