      SUBROUTINE CLUSTER
C----------------------------------------------------------------------
C-
C-   Purpose and Methods : IT FINDS THE NUMBER OF 
C-   CLUSTERS PER LAYER AND PER VIEW AND THE POSITION 
C-   OF THE CENTRE OF GRAVITY OF THE DETECTED ENERGY .
C-   IN THE MATRIX CLUS 2xNPLAxNCHA WE HAVE THE 
C-   CENTRES IN THE FIRST NCHA/2 ELEMENTS ORDERED FROM
C-   THE HIGHEST IN ENERGY TO THE LOWEST . THE SECOND
C-   NCHA/2 ELEMENTS ARE THE DETECTED ENERGIES IN 
C-   THESE CLUSTERS .
C-   IN THE MATRIX NCL 2xNPLA WE HAVE THE NUMBER OF 
C-   CLUSTERS PER LAYER .
C-
C-   Inputs  :
C-   Outputs :
C-   Controls:
C-
C-   Created   3-FEB-1994   MIRKO BOEZIO
C-   Modified  21-FEB-2003   MIRKO BOEZIO . INTRODUCED
C-   THE SHIFT IN THE SILICON DETECTORS PLACEMENT
C-   FOR THE CALL TO MILLIM IN BARIC .
C-
C-----------------------------------------------------
      INCLUDE 'INTEST.TXT'
      REAL QQQ(NCHA)
      INTEGER I

      COMMON / SHIFT / SHIFT
      SAVE / SHIFT /
C
      I = 0
      DO J = 1,NPLA
        DO N = 1,2
          DO M = 1,NCHA
            CLUS(N,J,M) = 0.
          ENDDO
          NCL(N,J) = 0
        ENDDO
      ENDDO
C
      DO N = 1,2
        DO J = 1,NPLA
          DO M = 1,NCHA
            QQQ(M) = 0.
            IF (DEXY(N,J,M).GT.EMIN) THEN
              QQQ(M) = DEXY(N,J,M)
            ENDIF
          ENDDO
C
          IGIRO = 0.
C
   50     CONTINUE
C
C THE FIRST CLUSTER FOR THE LAYER J IS THAT WITH THE
C HIGHEST DETECTED ENERGY .
C
          MAX = LVMAX(QQQ,NCHA)
          IF (QQQ(MAX).LT.EMIN) GO TO 100
          MSTR = MAX
   55     CONTINUE
          MSTR = MSTR + 1
          IF (MSTR.GT.NCHA) GO TO 56
          IF (QQQ(MSTR).GT.EMIN) GO TO 55
   56     CONTINUE
          IB = MSTR - 1
C
          MSTR = MAX
   65     CONTINUE
          MSTR = MSTR - 1
          IF (MSTR.LT.1) GO TO 66
          IF (QQQ(MSTR).GT.EMIN) GO TO 65
   66     CONTINUE
          IA = MSTR + 1
C
          NN = 0
          IF (M.EQ.2) NN = 1
          IF (MOD(I,2).EQ.NN) THEN
             SHIFT = +0.5
          ELSE
             SHIFT = -0.5
          ENDIF
          CALL BARIC(QQQ,IA,IB,BAR,ENE,IERR1)
          IGIRO = IGIRO + 1
          IGI = IGIRO + NCHA / 2
          CLUS(N,J,IGIRO) = BAR
          CLUS(N,J,IGI) = ENE
C
          DO LL = IA,IB
            QQQ(LL) = 0.
          ENDDO
          GO TO 50
C
  100     CONTINUE
          NCL(N,J) = IGIRO
        ENDDO
      ENDDO
C
      RETURN
      END


