//
// C/C++ headers
//
#include <fstream>
#include <string.h>
//
// ROOT headers
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TArrayI.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TSQLServer.h>
#include <TSQLRow.h>
#include <TSQLResult.h>
//#include <TClonesArray.h>
//
// RunInfo header
//
#include <RunInfo.h>
//
// YODA headers
//
#include <PamelaRun.h>
#include <physics/trigger/TriggerEvent.h>
#include <physics/anticounter/AnticounterEvent.h>
//
// RunInfo header
//
//#include <RunInfo.h>
//
// This program headers
//
#include <AcCore.h>
#include <AcLevel2.h>
#include <AcVerl2.h>
//
using namespace std;
//
// CORE ROUTINE
//
//
int AcCore(UInt_t run, TFile *file, GL_TABLES *glt, Int_t Acargc, char *Acargv[]){
  Int_t i = 0;
  Bool_t verbose = false;
  Bool_t debug = false;
  //
  TString processFolder = Form("AcFolder_%u",run);
  if ( Acargc > 0 ){
    i = 0;
    while ( i < Acargc ){
      if ( !strcmp(Acargv[i],"-processFolder") ) {
	if ( Acargc < i+1 ){
	  throw -3;
	};
	processFolder = (TString)Acargv[i+1];
	i++;
      };
      if ( !strcmp(Acargv[i],"-v") ||  !strcmp(Acargv[i],"--verbose") ) {
	verbose = true;
      };
      if ( !strcmp(Acargv[i],"-g") ||  !strcmp(Acargv[i],"--debug") ) {
	verbose = true;
	debug = true;
      };
      i++;
    };
  };
  //
  // Set these to true to have a very verbose output.
  //
  //
  // Output directory is the working directoy.
  //
  const char* outdir = gSystem->DirName(gSystem->DirName(file->GetPath()));
  //
  // Variables for level2 
  //
  TTree *ac = 0;
  UInt_t nevents = 0;
  //
  // variables needed to reprocess data
  //
  TString acversion;
  ItoRunInfo *runinfo = 0;
  TArrayI *runlist = 0;
  TTree *acclone = 0;
  Bool_t reproc = false;
  Bool_t reprocall = false;
  UInt_t nobefrun = 0;
  UInt_t noaftrun = 0;
  UInt_t numbofrun = 0;
  stringstream ftmpname;
  TString fname;
  UInt_t totfileentries = 0;
  UInt_t idRun = 0;
  //
  // variables needed to handle error signals
  //
  Int_t code = 0;
  Int_t sgnl;
  //
  // anticounter level2 classes
  //
  AcLevel2 *acl2 = new AcLevel2();
  AcLevel2 *acl2clone = new AcLevel2();
  // note: the string "mydect" is now "ac", "mydetector" is "anticounter" (mydectversion -> acversion, mydectclone -> acclone);
  // the string "mydec" (without t) -> acl2 (acl2, acl2clone)
  //
  // define variables for opening and reading level0 file
  //
  TFile *l0File = 0;
  TTree *l0tr = 0;
  TBranch *l0head = 0;
  TBranch *l0ac = 0;
  pamela::EventHeader *eh = 0;
  pamela::PscuHeader *ph = 0;
  pamela::anticounter::AnticounterEvent *acc = 0;
  //
  // Define other basic variables
  // 
  UInt_t procev = 0;
  stringstream file2;
  stringstream file3;
  stringstream qy;
  Int_t totevent = 0;
  UInt_t atime = 0;
  UInt_t re = 0;
  //
  // Working filename
  //
  TString outputfile;
  stringstream name;
  name.str("");
  name << outdir << "/";
  //
  // temporary file and folder
  //
  TFile *tempfile = 0;
  TTree *tempac = 0;
  stringstream tempname;
  stringstream acfolder;
  Bool_t myfold = false;
  tempname.str("");
  tempname << outdir;
  tempname << "/" << processFolder.Data();
  acfolder.str("");
  acfolder << tempname.str().c_str();
  tempname << "/ac2tree_run";
  tempname << run << ".root";  
  //
  // DB classes
  //
  GL_ROOT *glroot = new GL_ROOT();
  GL_TIMESYNC *dbtime = 0;
  //
  UShort_t CRCcheck[2]= {0,0};
  UShort_t Status[2]= {0,0};
  UShort_t Hitmap[2]= {0,0};
  UShort_t Hitstatus[2]= {0,0};
  UShort_t Trigger[2]  = {0,0};
  UShort_t Trigg_old[2] = {0,0};
  UShort_t Counter[2][16];
  UShort_t Counter_old[2][16];
  UShort_t Shift[2][16];
  Int_t vec[2][16][16];
  Int_t tmp = 0;
  memset(vec, 0, 2*16*16*sizeof(UShort_t));
  memset(Shift, 0, 2*16*sizeof(UShort_t));
  memset(Counter, 0, 2*16*sizeof(UShort_t));
  memset(Counter_old, 0, 2*16*sizeof(UShort_t));
  //
  Long64_t maxsize = 10000000000LL;  
  TTree::SetMaxTreeSize(maxsize);
  //
  //
  // Let's start!
  //
  //
  // As a first thing we must check what we have to do: if run = 0 we must process all events in the file has been passed
  // if run != 0 we must process only that run but first we have to check if the tree Anticounter already exist in the file
  // if it exists we are reprocessing data and we must delete that entries, if not we must create it.
  // 
  if ( run == 0 ) reproc = true;
  //
  // Output file is "outputfile"
  //
  outputfile = name.str().c_str(); 
  if ( verbose ) printf("\n Output filename is: \n %s \n\n",outputfile.Data());
  //
  // 
  if ( !file->IsOpen() ){
    if ( verbose ) printf(" ANTICOUNTER - ERROR: cannot open file for writing\n");
    throw -701;
  };
  //
  // Retrieve GL_RUN variables from the level2 file
  //  
  acversion = AcInfo(false); // we should decide how to handle versioning system
  //
  // create an interface to RunInfo called "runinfo"
  //
  runinfo = new ItoRunInfo(file);
  //
  // open "Run" tree in level2 file, if not existing return an error (sngl != 0)
  //
  sgnl = 0;
  sgnl = runinfo->Update(run,"AC",acversion);
  if ( sgnl ){
    if ( verbose ) printf(" ANTICOUNTER - ERROR: RunInfo exited with non-zero status\n");
    code = sgnl;
    goto closeandexit;
  } else {
    sgnl = 0;
  };
  //
  // number of events in the file BEFORE the first event of our run
  //
  nobefrun = runinfo->GetFirstEntry();
  //
  // total number of events in the file 
  //
  totfileentries = runinfo->GetFileEntries();
  //
  // first file entry AFTER the last event of our run
  //
  noaftrun = runinfo->GetLastEntry() + 1;
  //
  // number of run to be processed
  //
  numbofrun = runinfo->GetNoRun();
  UInt_t totnorun = runinfo->GetRunEntries();
  //
  // Try to access the Anticounter tree in the file, if it exists we are reprocessing data if not we are processing a new run
  //
  acclone = (TTree*)file->Get("Anticounter");
  //
  if ( !acclone ){
    //
    // tree does not exist, we are not reprocessing
    //
    reproc = false;
    if ( run == 0 && verbose ) printf(" ANTICOUNTER - WARNING: you are reprocessing data but AC tree does not exist!\n");
    if ( verbose &&  runinfo->IsReprocessing() && run != 0 ) printf(" ANTICOUNTER - WARNING: it seems you are not reprocessing data but Anticounter\n versioning information already exists in RunInfo.\n");

  } else {
    //
    // tree exists, we are reprocessing data. Are we reprocessing a single run or all the file?
    //
    acclone->SetAutoSave(900000000000000LL);
    reproc = true;
    //
    //
    if ( verbose ) printf("\n Preparing the pre-processing...\n");
    //
    if ( run == 0 || totnorun == 1 ){
      //
      // we are reprocessing all the file
      // if we are reprocessing everything we don't need to copy any old event and we can just work with the new tree and delete the old one immediately
      //
      reprocall = true;
      //
      if ( verbose ) printf("\n ANTICOUNTER - WARNING: Reprocessing all runs\n");
      //
    } else {
      //
      // we are reprocessing a single run, we must copy to the new tree the events in the file which preceed the first event of the run
      //
      reprocall = false;
      //
      if ( verbose ) printf("\n ANTICOUNTER - WARNING: Reprocessing run number %u \n",run);
      //
      // copying old tree to a new file
      //
      gSystem->MakeDirectory(acfolder.str().c_str());
      myfold = true;
      tempfile = new TFile(tempname.str().c_str(),"RECREATE");
      tempac = acclone->CloneTree(-1,"fast");
      tempac->SetName("Anticounter-old");
      tempfile->Write();
      tempfile->Close();  
    }
    //
    // Delete the old tree from old file and memory
    //
    acclone->Delete("all");
    //
    if ( verbose ) printf(" ...done!\n");
    //
  };
  //
  // create anticounter tree ac
  // 
  file->cd();
  ac = new TTree("Anticounter-new","PAMELA Level2 Anticounter data");
  ac->SetAutoSave(900000000000000LL);
  ac->Branch("AcLevel2","AcLevel2",&acl2);
  //
  if ( reproc && !reprocall ){
    //
    //  open new file and retrieve alo tree informations
    //
    tempfile = new TFile(tempname.str().c_str(),"READ");
    acclone = (TTree*)tempfile->Get("Anticounter-old");
    acclone->SetAutoSave(900000000000000LL);
    acclone->SetBranchAddress("AcLevel2",&acl2clone);
    //      
    if ( nobefrun > 0 ){
      if ( verbose ) {
	printf("\n Pre-processing: copying events from the old tree before the processed run\n");   
	printf(" Copying %u events in the file which are before the beginning of the run %u \n",nobefrun,run);
	printf(" Start copying at event number 0, end copying at event number %u \n",nobefrun);
      };
      for (UInt_t j = 0; j < nobefrun; j++){
	//
	acclone->GetEntry(j);	  
	//
	// copy acl2clone to acl2
	//
	acl2->Clear();
	//
	memcpy(&acl2,&acl2clone,sizeof(acl2clone));
	//
	// Fill entry in the new tree
	//
	ac->Fill();
	//
      };
      if ( verbose ) printf(" Finished successful copying!\n");
    };          
  };
  //
  // Get the list of run to be processed, if only one run has to be processed the list will contain one entry only.
  //
  runlist = runinfo->GetRunList();
  //
  // Loop over the run to be processed
  //
  for (UInt_t irun=0; irun < numbofrun; irun++){
    //
    // retrieve the first run ID to be processed using the RunInfo list
    //
    idRun = runlist->At(irun);
    if ( verbose ){
      printf("\n\n\n ####################################################################### \n");
      printf("                    PROCESSING RUN NUMBER %u \n",idRun);
      printf(" ####################################################################### \n\n\n");
    };
    //
    runinfo->ID_ROOT_L0 = 0;
    //
    // store in the runinfo class the GL_RUN variables for our run
    //
    sgnl = 0;
    sgnl = runinfo->GetRunInfo(idRun);
    if ( sgnl ){
      if ( verbose ) printf(" ANTICOUNTER - ERROR: RunInfo exited with non-zero status\n");
      code = sgnl;
      goto closeandexit;
    } else {
      sgnl = 0;
    };
    //
    // now you can access that variables using the RunInfo class this way runinfo->ID_ROOT_L0
    //
    if ( runinfo->ID_ROOT_L0 == 0 ){
      if ( verbose ) printf("\n ANTICOUNTER - ERROR: no run with ID_RUN = %u \n\n Exiting... \n\n",idRun);
      code = -5;
      goto closeandexit;    
    };
    //
    // prepare the timesync for the db
    //
    TString host = glt->CGetHost();
    TString user = glt->CGetUser();
    TString psw = glt->CGetPsw();
    TSQLServer *dbc = TSQLServer::Connect(host.Data(),user.Data(),psw.Data());   
    if ( !dbc->IsConnected() ) throw -705;
    dbtime = new GL_TIMESYNC(runinfo->ID_ROOT_L0,"ID",dbc);
    //
    // Search in the DB the path and name of the LEVEL0 file to be processed.
    //
    //    if ( !dbc->IsConnected() ) throw -705;
    glroot->Query_GL_ROOT(runinfo->ID_ROOT_L0,dbc);
    //
    ftmpname.str("");
    ftmpname << glroot->PATH.Data() << "/";
    ftmpname << glroot->NAME.Data();
    fname = ftmpname.str().c_str();
    //
    // print out informations
    //
    totevent = runinfo->NEVENTS;
    if ( verbose ) {
      printf("\n LEVEL0 data file: %s \n",fname.Data());
      printf(" RUN HEADER absolute time is:  %u \n",runinfo->RUNHEADER_TIME);
      printf(" RUN TRAILER absolute time is: %u \n",runinfo->RUNTRAILER_TIME);
      printf(" %i events to be processed for run %u: from %i to %i \n\n",totevent,idRun,runinfo->EV_FROM,runinfo->EV_FROM+totevent);
    };
    //
    // Open Level0 file
    //
    l0File = new TFile(fname.Data());
    if ( !l0File ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: problems opening  Level0 file\n");
      code = -6;
      goto closeandexit;
    };
    l0tr = (TTree*)l0File->Get("Physics");
    if ( !l0tr ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: no Physics tree in Level0 file\n");
      l0File->Close();
      code = -7;
      goto closeandexit;
    };
    l0head = l0tr->GetBranch("Header");
    if ( !l0head ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: no Header branch in Level0 tree\n");
      l0File->Close();
      code = -8;
      goto closeandexit;    
    };
    l0ac = l0tr->GetBranch("Anticounter");
    if ( !l0ac ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: no Anticounter branch in Level0 tree\n");
      l0File->Close();
      code = -704;
      goto closeandexit;
    };
    //
    l0tr->SetBranchAddress("Anticounter", &acc);
    l0tr->SetBranchAddress("Header", &eh);
    //
    nevents = l0ac->GetEntries();
    //
    if ( nevents < 1 ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: Level0 file is empty\n\n");
      l0File->Close();
      code = -11;
      goto closeandexit;
    };
    //
    if ( runinfo->EV_TO > nevents-1 ) {
      if ( verbose ) printf(" ANTICOUNTER - ERROR: too few entries in the tree\n");
      l0File->Close();
      code = -12;
      goto closeandexit;
    };
    //
    // run over all the events of the run
    //
    if ( dbc ){
      dbc->Close();
      delete dbc;
    };
    //
    if ( verbose ) printf("\n Ready to start! \n\n Processed events: \n\n");
    //
    for ( re = runinfo->EV_FROM; re < (runinfo->EV_FROM+runinfo->NEVENTS); re++){
      //
      if ( procev%1000 == 0 && procev > 0 && verbose ) printf(" %iK \n",procev/1000);	
      //
      l0head->GetEntry(re);
      //
      // absolute time of this event
      //
      ph = eh->GetPscuHeader();
      atime = dbtime->DBabsTime(ph->GetOrbitalTime());  
      //
      // paranoid check
      //
      if ( atime > runinfo->RUNTRAILER_TIME || atime < runinfo->RUNHEADER_TIME  ) {
	if ( verbose ) printf(" ANTICOUNTER - WARNING: event at time outside the run time window, skipping it\n");
	goto jumpev;
      };
      //
      procev++;
      //
      // start processing
      //
      acl2->Clear();
      //
      l0ac->GetEntry(re);
      //
      /***********************************************/
      // Here starts Anticounter specific code (Silvio)
      //
      memset(vec, 0, 2*16*16*sizeof(UShort_t));
      memset(Shift, 0, 2*16*sizeof(UShort_t));
      memset(Counter, 0, 2*16*sizeof(UShort_t));
      memset(Counter_old, 0, 2*16*sizeof(UShort_t));
      memset(CRCcheck, 0, 2*sizeof(UShort_t));
      memset(Status, 0, 2*sizeof(UShort_t));
      memset(Hitmap, 0, 2*sizeof(UShort_t));
      memset(Hitstatus, 0, 2*sizeof(UShort_t));
      memset(Trigger, 0, 2*sizeof(UShort_t));
      memset(Trigg_old, 0, 2*sizeof(UShort_t));
      tmp = 0;
      //
      for(Int_t gg = 0; gg < 2; gg++)
	{
	  Hitstatus[gg] = 0;
	}
      //
      //fetch data
      //
      for(Int_t kk = 0; kk < 2; kk++)
	{
	  if(re>0)
	    {
	      Trigg_old[kk] = Trigger[kk];
	      for(Int_t jj = 0; jj < 16; jj++)
		Counter_old[kk][jj] = Counter[kk][jj];
	    }
	  
	  for(Int_t jj = 0; jj < 16; jj++)
	    {
	      Counter[kk][jj] = acc->counters[kk][jj];
	      Shift[kk][jj] = acc->shift[kk][jj];
	    }
	  Status[kk] = acc->status[kk];
	  Hitmap[kk] = acc->hitmap[kk];
	  Trigger[kk] = acc->trigg[kk];
	  CRCcheck[kk] = acc->CRCcheck[kk];
	}
      
      /***********************************************/
      //process data
      /***********************************************/
      //shiftregisters
      for(Int_t b = 0; b < 2; b++){ //card
	for(Int_t k = 0; k < 16; k++){ //shift register
	  Int_t cnt=1;
	  for(Int_t l = 0; l < 16; l++){ //bin
	    tmp = ((Shift[b][k] & cnt) > 0 ? 1 : 0);
	    vec[b][k][l]=tmp;
	    cnt=cnt<<1;
	  }
	  //cnt=1;
	}
      }
      //
      //fill Level1 file
      /************************************************/
      for(Int_t s = 0; s < 2; s++) {
	acl2->hitmap[s] = Hitmap[s];
	acl2->trigger[s] = Trigger[s];
	Int_t cnt=1;
	for(Int_t k = 0; k < 16; k++) {
	  for(Int_t bin = 5; bin < 9; bin++) { //acceptance window
	    if(vec[s][bin][k]==1)
	      Hitstatus[s] = Hitstatus[s] | cnt;
	  }
	  cnt=cnt<<1;
	}
	acl2->hitstatus[s] = Hitstatus[s];
	//	
	//Status
	/****************************************/
	if(s==0){
	  if(Trigger[0] != (Trigg_old[0]+1))
	    acl2->status[0] = acl2->status[0] | 0x1;
	  if(Status[0] & 0x001F < 0x001F)
	    acl2->status[0] = acl2->status[0] | 0x2;
	  if(CRCcheck[0] == 0)
	    acl2->status[0] = acl2->status[0] | 0x4;
	  for(Int_t gg = 0; gg < 16; gg++){
	    if((Counter[0][gg] == Counter_old[0][gg]) && re>0){
	      acl2->status[0] = acl2->status[0] | 0x8;
	    }
	  }
	}
	else {
	  if(Trigger[1] != (Trigg_old[1]+2))
	    acl2->status[1] = acl2->status[1] | 0x1;
	  if(Status[1] & 0x001F < 0x001F)
	    acl2->status[1] = acl2->status[1] | 0x2;
	  if(CRCcheck[1] == 0)
	    acl2->status[1] = acl2->status[1] | 0x4;
	  for(Int_t gg = 0; gg < 16; gg++){
	    if((Counter[1][gg] == Counter_old[1][gg]) && re>0)
	      acl2->status[1] = acl2->status[1] | 0x8;
	  }
	}
      }
      //
      // End Anticounter specific code
      //
      /************************************************/      
      acl2->unpackError = acc->unpackError;
      //
      // Fill the rootple 
      //
      ac->Fill();
      //    
      //
    jumpev:
      debug = false;
      //
    };
    //
    // Here you may want to clear some variables before processing another run  
    //
    delete dbtime;
  }; // process all the runs
  //
  if ( verbose ) printf("\n Finished processing data \n");
  //
 closeandexit:
  //
  // we have finished processing the run(s). If we processed a single run now we must copy all the events after our run from the old tree to the new one and delete the old tree.
  //
  if ( !reprocall && reproc && code >= 0 ){
    if ( totfileentries > noaftrun ){
      if ( verbose ){
	printf("\n Post-processing: copying events from the old tree after the processed run\n");   
	printf(" Copying %i events in the file which are after the end of the run %i \n",(int)(totfileentries-noaftrun),(int)run);
	printf(" Start copying at event number %i end copying at event number %i \n",(int)noaftrun,(int)totfileentries);
      };
      for (UInt_t j = noaftrun; j < totfileentries; j++ ){
	//
	// Get entry from old tree
	//
	acclone->GetEntry(j);	  
	//
	// copy acl2clone to acl2
	//
	acl2->Clear();
	memcpy(&acl2,&acl2clone,sizeof(acl2clone));
	//
	// Fill entry in the new tree
	//
	ac->Fill();
      };
      if ( verbose ) printf(" Finished successful copying!\n");
    };
  };
  //
  // Close files, delete old tree(s), write and close level2 file 
  //
  if ( l0File ) l0File->Close();
  if ( tempfile ) tempfile->Close();            
  if ( myfold ) gSystem->Unlink(tempname.str().c_str());
  //
  if ( code < 0 && verbose ) printf("\n ANTICOUNTER - ERROR: an error occurred, try to save anyway...\n");
  if ( verbose ) printf("\n Writing and closing rootple\n");
  if ( runinfo ) runinfo->Close();    
  if ( ac ) ac->SetName("Anticounter");    
  if ( file ){
    file->cd();
    file->Write();
  };
  //
  if ( myfold ) gSystem->Unlink(acfolder.str().c_str());
  //
  // the end
  //
  if ( verbose ) printf("\n Exiting...\n");
  //
  if( ac ) ac->Delete();
  if ( acl2 ) delete acl2;
  if ( acl2clone ) delete acl2clone;
  if ( glroot ) delete glroot;
  if ( runinfo ) delete runinfo; 
  //
  if(code < 0) throw code;
  return(code);
}


