#include <TObject.h>
#include <AcLevel2.h>
ClassImp(AcLevel2);

AcLevel2::AcLevel2() {
  status[0]=0;
  hitmap[0]=0;
  hitstatus[0]=0;
  trigger[0]=0;
  status[1]=0;
  hitmap[1]=0;
  hitstatus[1]=0;
  trigger[1]=0;
} 

void AcLevel2::Clear(){
  status[0]=0;
  hitmap[0]=0;
  hitstatus[0]=0;
  trigger[0]=0;
  status[1]=0;
  hitmap[1]=0;
  hitstatus[1]=0;
  trigger[1]=0;
}

/**
 * Fills a struct cAcLevel2 with values from a AcLevel2 object (to put data into a F77 common).
 */
void AcLevel2::GetLevel2Struct(cAcLevel2 *l2) const{
  for(int i=0;i<2;i++){
    l2->status[i]    = status[i];
    l2->hitmap[i]    = hitmap[i];
    l2->hitstatus[i] = hitstatus[i];
    l2->trigger[i]   = trigger[i];
  }
}

void AcLevel2::SetFromLevel2Struct(cAcLevel2 *l2){
  for(int i=0;i<2;i++){
    status[i]    = l2->status[i];
    hitmap[i]    = l2->hitmap[i];
    hitstatus[i] = l2->hitstatus[i];
    trigger[i]   = l2->trigger[i];
  }
}
