/**
 * \file src/AcLevel2.cpp
 * \author Petter Hofverberg
**/
#include <TObject.h>
#include <AcLevel2.h>

ClassImp(AcLevel2);

/**
 * AcLevel2 constructor
**/
AcLevel2::AcLevel2() {
  this->Clear();
} 

/**
 * Clear variables
**/
void AcLevel2::Clear(Option_t *t){
  status[0]=0;
  hitmap[0]=0;
  hitstatus[0]=0;
  trigger[0]=0;
  status[1]=0;
  hitmap[1]=0;
  hitstatus[1]=0;
  trigger[1]=0;
  unpackError=0;
}

/**
 * checks if detector what is hit
**/ 
bool AcLevel2::IsHit(TString what){

    char* cabl[] = {"CARD4","CAT2","CAS1","ND","CARD2","CAT4","CAS4","ND",
		    "CARD3","CAT3","CAS3","ND","CARD1","CAT1","CAS2","ND"};

    bool answer = false;
    for(Int_t ibit=0; ibit<16; ibit++){
	if( what.Contains( cabl[ibit], TString::kIgnoreCase ) ){
	    if( what.Contains( "M" , TString::kIgnoreCase ) )
		answer = (Bool_t)((hitmap[0]>>ibit)&1) & (Bool_t)((hitstatus[0]>>ibit)&1);
	    else if( what.Contains( "E" , TString::kIgnoreCase ) )
		answer = (Bool_t)((hitmap[1]>>ibit)&1) & (Bool_t)((hitstatus[1]>>ibit)&1);
	    return answer;
	};
    };
    return answer;

}
/**
 * is CAS hit?
**/
bool AcLevel2::CAShit(TString card)
{
  if(card.Contains("main") || card.CompareTo("")==0 )
    {
      if( this->IsHit("CAS1-M") )return true;
      if( this->IsHit("CAS2-M") )return true;
      if( this->IsHit("CAS3-M") )return true;
      if( this->IsHit("CAS4-M") )return true;
    }
  if(card.Contains("extra") || card.CompareTo("")==0)
    {
      if( this->IsHit("CAS1-E") ) return true;
      if( this->IsHit("CAS2-E") ) return true;
      if( this->IsHit("CAS3-E") ) return true;
      if( this->IsHit("CAS4-E") ) return true;
    }
  
  return false;
}
/**
 * is CAT hit?
**/
bool AcLevel2::CAThit(TString card)
{
  if(card.Contains("main") || card.CompareTo("")==0 )
    {
      if( this->IsHit("CAT1-M") )return true;
      if( this->IsHit("CAT2-M") )return true;
      if( this->IsHit("CAT3-M") )return true;
      if( this->IsHit("CAT4-M") )return true;
    }
  if(card.Contains("extra") || card.CompareTo("")==0)
    {
      if( this->IsHit("CAT1-E") ) return true;
      if( this->IsHit("CAT2-E") ) return true;
      if( this->IsHit("CAT3-E") ) return true;
      if( this->IsHit("CAT4-E") ) return true;
    }
  
  return false;
}
/**
 * is CARD hit?
**/
bool AcLevel2::CARDhit(TString card)
{
  if(card.Contains("main") || card.CompareTo("")==0 )
    {
      if( this->IsHit("CARD1-M") )return true;
      if( this->IsHit("CARD2-M") )return true;
      if( this->IsHit("CARD3-M") )return true;
      if( this->IsHit("CARD4-M") )return true;
    }
  if(card.Contains("extra") || card.CompareTo("")==0)
    {
      if( this->IsHit("CARD1-E") ) return true;
      if( this->IsHit("CARD2-E") ) return true;
      if( this->IsHit("CARD3-E") ) return true;
      if( this->IsHit("CARD4-E") ) return true;
    }
  
  return false;
}
/**
 * is AC hit?
**/
bool AcLevel2::AChit(TString card)
{
  if(this->CAThit(card) || this->CARDhit(card) || this->CAShit(card)) return true;

  return false;
}


/**
 * Fills a struct cAcLevel2 with values from a AcLevel2 object (to put data into a F77 common).
 */
void AcLevel2::GetLevel2Struct(cAcLevel2 *l2) const{
  for(int i=0;i<2;i++){
    l2->status[i]    = status[i];
    l2->hitmap[i]    = hitmap[i];
    l2->hitstatus[i] = hitstatus[i];
    l2->trigger[i]   = trigger[i];
  }
}

void AcLevel2::SetFromLevel2Struct(cAcLevel2 *l2){
  for(int i=0;i<2;i++){
    status[i]    = l2->status[i];
    hitmap[i]    = l2->hitmap[i];
    hitstatus[i] = l2->hitstatus[i];
    trigger[i]   = l2->trigger[i];
  }
}

