/**
 * \file inc/AcLevel2.h
 * \author Petter Hofverberg
 */

#ifndef AcLevel2_h
#define AcLevel2_h
//
#include <TObject.h>
#include <TString.h>
//
#include <AcStruct.h>
//
/**
 * \Anticounter Level2 class 
 **/
class AcLevel2 : public TObject {
 private:

 public:
 
  Int_t status[2];   ///< the status word [0] main board, [1] extra board. 0x0 means ok
  Int_t hitmap[2];   ///< 16 bit binary hitmap. 1-hit, 0-not hit. Use XHit-functions instead of this
  Int_t hitstatus[2]; ///< if hit is correlated with trigger. 1-yes, 0-no. This is checked in XHit-functions
  Int_t trigger[2];  ///<trigger counter

  bool IsHit(TString); ///< is detector x hit? String can be CARD1-M, CAS3-E and so on
  bool CAShit(TString card="");   ///< CAS hit?  Default (main || extra). Arguments "main","extra"
  bool CARDhit(TString card="");  ///< CARD hit? Default (main || extra). Arguments "main" ,"extra" 
  bool CAThit(TString card="");   ///< CAT hit?  Default (main || extra). Arguments "main","extra"
  bool AChit(TString card="");    ///< AC hit?   Default (main || extra). Arguments "main","extra"

  Int_t unpackError; // Emiliano

  // constructor
  AcLevel2(); ///< constructor
  AcLevel2* GetAcLevel2(){return this;}; ///< returns pointer to this object 
  void GetLevel2Struct(cAcLevel2 *) const;
  void SetFromLevel2Struct(cAcLevel2 *);

  void Clear(); ///< clear variables
  //
  ClassDef(AcLevel2, 2); 
};


#endif
