/**
 * \file TrkHough.cpp
 * \author David Fedele
 */
#include <TrkHough.h>
#include <iostream>
using namespace std;

//--------------------------------------
//
//
//--------------------------------------
TrkHough::TrkHough(){
  
  ndblt=0; 
  alfayz1=0; 
  alfayz2=0; 
  db_cloud=0;
  
  ntrpt=0;  
  alfaxz1=0;
  alfaxz2=0;
  alfaxz3=0;
  tr_cloud=0;
  
  nclouds_yz=0;
  alfayz1_av=0;
  alfayz2_av=0;
  ptcloud_yz=0;
  
  nclouds_xz=0; 
  alfaxz1_av=0;
  alfaxz2_av=0;
  alfaxz3_av=0;
  ptcloud_xz=0;
  
  nclstr=0;
  totaltime=0;
  houghtime=0;
  fittime=0;

};
//--------------------------------------
//
//
//--------------------------------------
TrkHough::~TrkHough(){
    
  delete [] alfayz1; 
  delete [] alfayz2; 
  delete [] db_cloud;
    
  delete [] alfaxz1;
  delete [] alfaxz2;
  delete [] alfaxz3;
  delete [] tr_cloud;
  
  delete [] alfayz1_av;
  delete [] alfayz2_av;
  delete [] ptcloud_yz;
     
  delete [] alfaxz1_av;
  delete [] alfaxz2_av;
  delete [] alfaxz3_av;
  delete [] ptcloud_xz;
  
};
//--------------------------------------
//
//
//--------------------------------------
/**
 * Fills a TrkHough object with values from a struct cTrkhough (to get data from F77 common).
 */
void TrkHough::SetFromHoughStruct(cTrkHough *lh){

  ndblt          = lh->ndblt_nt;
  ntrpt          = lh->ntrpt_nt;
  nclouds_yz     = lh->nclouds_yz_nt;
  nclouds_xz     = lh->nclouds_xz_nt;
  nclstr         = lh->nclstr;
  totaltime      = lh->totaltime;
  houghtime      = lh->houghtime;
  fittime        = lh->fittime;

  alfayz1        = new Float_t[ndblt];
  alfayz2        = new Float_t[ndblt];
  db_cloud       = new Int_t[ndblt];
  for(int i=0; i<ndblt; i++){
    alfayz1[i]   = (Float_t) lh->alfayz1_nt[i];
    alfayz2[i]   = (Float_t) lh->alfayz2_nt[i];
    db_cloud[i]  = (Int_t) lh->db_cloud_nt[i];
  }

  alfaxz1        = new Float_t[ntrpt];
  alfaxz2        = new Float_t[ntrpt];
  alfaxz3        = new Float_t[ntrpt];
  tr_cloud       = new Int_t[ntrpt];
  for(int i=0; i<ntrpt; i++){
    alfaxz1[i]   = (Float_t) lh->alfaxz1_nt[i];
    alfaxz2[i]   = (Float_t) lh->alfaxz2_nt[i];
    alfaxz3[i]   = (Float_t) lh->alfaxz3_nt[i];
    tr_cloud[i]  = (Int_t) lh->tr_cloud_nt[i];
  }
  
  alfayz1_av        = new Float_t[nclouds_yz];
  alfayz2_av        = new Float_t[nclouds_yz];
  ptcloud_yz        = new Int_t[nclouds_yz];
  for(int i=0; i<nclouds_yz; i++){
    alfayz1_av[i]   = (Float_t) lh->alfayz1_av_nt[i];
    alfayz2_av[i]   = (Float_t) lh->alfayz2_av_nt[i];
    ptcloud_yz[i]   = (Int_t) lh->ptcloud_yz_nt[i];
  }
  
  alfaxz1_av        = new Float_t[nclouds_xz];
  alfaxz2_av        = new Float_t[nclouds_xz];
  alfaxz3_av        = new Float_t[nclouds_xz];
  ptcloud_xz        = new Int_t[nclouds_xz];
  for(int i=0; i<nclouds_xz; i++){
    alfaxz1_av[i]   = (Float_t) lh->alfaxz1_av_nt[i] ;
    alfaxz2_av[i]   = (Float_t) lh->alfaxz2_av_nt[i];
    alfaxz3_av[i]   = (Float_t) lh->alfaxz3_av_nt[i];
    ptcloud_xz[i]   = (Int_t) lh->ptcloud_xz_nt[i];
  }
};
//--------------------------------------
//
//
//--------------------------------------
void TrkHough::Clear(){
 
    ndblt = 0;
    ntrpt = 0;
    nclouds_yz = 0;
    nclouds_xz = 0;
    nclstr = 0;
    totaltime = 0;
    houghtime = 0;
    fittime = 0;

};
//--------------------------------------
//
//
//--------------------------------------
void TrkHough::Delete(){

    ndblt = 0;
    ntrpt = 0;
    nclouds_yz = 0;
    nclouds_xz = 0;
    nclstr = 0;
    totaltime = 0;
    houghtime = 0;
    fittime = 0;

    this->~TrkHough();

};


ClassImp(TrkHough);
