*************************************************************************
*     Program analysis.f
*
*     - reads cluster information (LEVEL1, reduction.f output ntuple)
*     - perform track identification and fit
*     - create LEVEL2 ntuple
*
*************************************************************************
      subroutine analysisflight

      include 'commontracker.f'
      include 'level1.f'
      include 'common_momanhough.f'
      include 'common_mech.f'
      include 'common_xyzPAM.f'
      include 'common_mini_2.f'
      include 'calib.f'
      include 'level2.f'

*     input flag
*
c      integer fin

*     flag to chose PFA
      character*10 PFA
      common/FINALPFA/PFA

c      parameter (inf=1.e8)      !just a huge number...
        
*     external functions
      external npl
      external acoordsi,coordsi,nld,coord,dcoord

************************************************************
************************************************************
************************************************************
*
*     track analysis
*
************************************************************
************************************************************
************************************************************
c$$$      TRACKMODE = 0
c$$$      FACT = 100.
c$$$      ISTEPMIN = 3

      call idtoc(pfaid,PFA)
      
c$$$      PFA='COG4'
c$$$      if(pfaid.eq.0)PFA='ETA'
c$$$      if(pfaid.eq.2)PFA='ETA2'
c$$$      if(pfaid.eq.3)PFA='ETA3'
c$$$      if(pfaid.eq.4)PFA='ETA4'
c$$$      if(pfaid.eq.10)PFA='COG'
c$$$      if(pfaid.eq.11)PFA='COG1'
c$$$      if(pfaid.eq.12)PFA='COG2'
c$$$      if(pfaid.eq.13)PFA='COG3'
c$$$      if(pfaid.eq.14)PFA='COG4'
***********************************************************

c      if(DEBUG)PRINT*,'P.F.A. --> ',fin,PFA

      if(DEBUG)then
         print*,'----------------------------------'
         print*,'Settings: '
         print*,'PFA                  ',pfaid,PFA
         print*,'tracking mode        ',trackmode
         print*,'fit-tolerance factor ',fact
         print*,'minimum n.step       ',istepmin
      endif

*------------------------------------------------------
      call init_level2
      call init_hough
*------------------------------------------------------
      
*------------------------------------------------------
*     cut on maximum number of clusters
*------------------------------------------------------
c$$$      if(nclstr1.gt.nclstrmax_level2)then
c$$$         goto 8800              !fill nt-uple and go to next event
c$$$      endif
      
      do i=1,nclstr1
         cl_used(i)=0           !init mask of clusters associated to a track
      enddo
      
      if(DEBUG)then
         print*,'----------------------------------'
         print*,iev,'   ** ',nev2
      endif

*     ///////////////////////////////////////////////
*     \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

      iflag=0
      call track_finding(iflag)
      if(iflag.eq.1)then        !bad event
         goto 880               !fill ntp and go to next event     
      endif 

      call fill_hough

      iflag=0
      call track_fitting(iflag)
      if(iflag.eq.1)then        !bad event
         goto 880               !fill ntp and go to next event     
      endif 
      


 880  continue

*     **********************************************************
*     stores info about clusters not associated with any track
*     **********************************************************

      call fill_level2_siglets
      
      if(DEBUG)then
            
         print*,''
         print*,'DONE!'
         print*,''
         print*,'* summary *'
         print*,'tracks    ',ntrk
         print*,'cl used   ',(cl_used(i),i=1,nclstr1)
         print*,''
         print*,''
      endif

      ngood = 0
      do iv = 1,nviews
         ngood = ngood + good1(iv)
      enddo
c$$$      if(ngood.ne.0)print*,'* WARNING * Event '
c$$$     $     ,':LEVEL2 event status: '
c$$$     $     ,(good2(i),i=1,nviews)
      
 8800 continue
      
      
*     ///////////////////////////////////////////////
*     \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

 100  continue
      
      return
      end
      

************************************************************


