/**
 * \file TrkLevel0.h
 * \author Elena Vannuccini
 */
#ifndef trklevel0_h
#define trklevel0_h

#include <TObject.h>
#include <physics/tracker/TrackerEvent.h>
#include <TrkParams.h>
//#include <TrkStruct.h>

using namespace pamela::tracker;

/**
 * \brief Class to describe tracker LEVEL0 data. 
 *
 */

//class TrkLevel0 : public TrackerEvent{
class TrkLevel0 : public TObject{

 private:

    TrackerEvent* yodaobj;

 public:

    TrkLevel0(){ yodaobj = 0; };
    ~TrkLevel0(){ if(yodaobj) delete yodaobj; };
    void Set(){ yodaobj = new TrackerEvent(); };    

//    void GetCommonVar(cTrkLevel0 *);
    void GetLevel0Struct(cTrkLevel0 *);
    void SetFromLevel0Struct(cTrkLevel0 *);
    void GetLevel0Struct(){ GetLevel0Struct(&level0event_); };
    void SetFromLevel0Struct(){ SetFromLevel0Struct(&level0event_); };

//    cTrkLevel0* GetLevel0Struct(){ GetCommonVar(&level0event_); };
    void* GetPointerToTrackerEvent(){ return &yodaobj; };
    TrackerEvent* GetTrackerEvent(){ return yodaobj; }
    int ProcessEvent();
    
    ClassDef(TrkLevel0,1);
 
};

#endif
