C-------------------------------------------------
C     output files logical units
C-------------------------------------------------
      parameter (lun_file_out=70) !output file id number
      parameter (lun_file_log=73) !log file id number
      parameter (lun_file_eta=74) !eta param file id number


c$$$C-------------------------------------------------
c$$$C     variables for the good track identification 
c$$$C-------------------------------------------------
c$$$      real xpa(nplanes),ypa(nplanes) !PAMELA frame measured coordinates
c$$$      real xres(nplanes),yres(nplanes) !residuals
c$$$      real chix,chiy            !chi-squared
c$$$      real thetax,thetay        !incidence angle
c$$$      real xsi(nplanes),ysi(nplanes) !silicon sensor frame measured coordinates
c$$$      integer lad(nplanes)      !hit ladders
c$$$      integer isensor(nplanes)  !hit sensors
      integer which_cl_x(nplanes),which_cl_y(nplanes)
c$$$c      real fitz(nplanes)        !z coordinates of the planes
c$$$
      common/good_track_cl/
c$$$c     $     fitz,
c$$$     $     xpa,ypa,xres,yres,
c$$$     $     chix,chiy,
c$$$     $     thetax,thetay,
c$$$     $     xsi,ysi,
c$$$     $     lad,isensor,
     $     which_cl_x,which_cl_y

C-------------------------------------------------
C     level1 n-tuple with selected events
C-------------------------------------------------
      
c      parameter (ntp_level1_tmp=41)

C-------------------------------------------------
C     some check histos 
C-------------------------------------------------
      parameter (id_hi_chi=10000)
      parameter (id_hi_mult=7000000)
      parameter (id_hi_charge=8000000)

      parameter (id_hi_angle=9000000)
      parameter (id_hi_angle_stat=9900000)

      parameter (id_hi_beam=5000000)

      parameter (id_hi_bx=2000)
      parameter (id_hi_by=3000)   
      parameter (id_hi_bz=4000)

c------------------------------------------------------------------------
c     
c     eta-2 eta-3 eta-4 histograms
c     
c     here is defined the histogram and angular binning
c     for eta corrections
c------------------------------------------------------------------------

      parameter (id_hi_eta2=20000)
      parameter (id_hi_eta3=30000)
      parameter (id_hi_eta4=40000)   

      parameter (nhbin2=100)      !eta-2 histo bins
      parameter (nhbin3=2*nhbin2) !eta-3 histo bins
      parameter (nhbin4=3*nhbin2) !eta-4 histo bins

c$$$      real histo2(nhbin2)
c$$$      real eta2corr(nhbin2+1,nviews) !eta2 correction
c$$$      real eta2abs(nhbin2+1)         !eta2 abscissa


c$$$# ifdef TEST2003
c$$$      parameter (nangbin=3)       !number of angular bins
c$$$c      real angbin(nang+1)       !bin extremes
c$$$      data angbin/              !nang=3
c$$$     $     -6.0,
c$$$     $     -2.0,
c$$$     $      2.0,
c$$$     $      6.0/
c$$$# else
c$$$      parameter (nangbin=3)       !number of angular bins
c$$$c      real angbin(nang+1)       !bin extremes
c$$$      data angbin/              !nang=3
c$$$     $     -6.0,
c$$$     $     -2.0,
c$$$     $      2.0,
c$$$     $      6.0/
c$$$# endif

c$$$      parameter (nangmax=50)
c$$$      integer nang,angbin(nangmax)
      real avangbin(nangmax,nviews),navangbin(nangmax,nviews) !average angle in the bin
      common/avang/avangbin,navangbin

c------------------------------------------------------------------------
c     
c     charge correlation histograms
c
c------------------------------------------------------------------------
      parameter (id_hi_chargeco=500000)

      real syksx(nplanes),sycsx(nplanes)
      real esyksx(nplanes),esycsx(nplanes)
      common/sxsy/syksx,sycsx,esyksx,esycsx

*     ---------------------------------------------
*     common per la correlazione di carica (MINUIT)
      parameter (ncorrmax=10000)
      real chargexy(nplanes,3,ncorrmax,2)
      integer whichplane,whichladder,goodtr
      common/chargecorr/chargexy,whichplane,whichladder,goodtr

c      double precision val,error
c      character*12 chnam
c      real esyksx(nplanes),esycsx(nplanes)
*     ---------------------------------------------

