/**
 * \file TrkStruct.h
 * \author Elena Vannuccini
 * \date
 */
#include <TrkStruct.h>


using namespace pamela;
using namespace std;

float aint(float f){
    int   ret  = (int)f;
    float ret1 = 0;
    ret1=(float)ret;
    return ret1;	
}

float anint(float f){
    int   ret  = (int)(f+0.5);
    float ret1 = 0;
    ret1=(float)ret;
  return ret1;	
}
/**
 * Method to fill the tracker calibration-parameter struct from on-line calibrations
 */
void cTrkCalib::FillACalibFrom(TFile* f0, Int_t ev_reg1, Int_t ev_reg2){

	TTree *tr1 = (TTree*)f0->Get("CalibTrk1");  
	TTree *tr2 = (TTree*)f0->Get("CalibTrk2"); 

	CalibTrk1Event *calibdata1 = 0;
	CalibTrk2Event *calibdata2 = 0;
	tr1->SetBranchAddress("CalibTrk1",&calibdata1);
	tr2->SetBranchAddress("CalibTrk2",&calibdata2);
	tr1->GetEntry(ev_reg1);
	tr2->GetEntry(ev_reg2); 
	Int_t dspn1(0),dspn2(0);
	
	for(Int_t i=0;i<6;i++){
		dspn1=calibdata1->DSPnumber[i]-1;
		dspn2=calibdata2->DSPnumber[i]-1;
	/*     cout<<"dspn1= "<<dspn1<<"   dspn2= "<<dspn2<<endl; */
		for(Int_t ii=0;ii<3072;ii++){
			Int_t j=(ii/128);
			Int_t jj=ii-j*128; 
			pedestal[jj][j][dspn1]=calibdata1->DSPped_par[i][ii];
			pedestal[jj][j][dspn2]=calibdata2->DSPped_par[i][ii];
			pedestal_t[jj][j][dspn1]=aint(calibdata1->DSPped_par[i][ii]);
			pedestal_t[jj][j][dspn2]=aint(calibdata2->DSPped_par[i][ii]);
			sigma[jj][j][dspn1]=calibdata1->DSPsig_par[i][ii];
			sigma[jj][j][dspn2]=calibdata2->DSPsig_par[i][ii];
			sigma_t[jj][j][dspn1]=anint(calibdata1->DSPsig_par[i][ii]);
			sigma_t[jj][j][dspn2]=anint(calibdata2->DSPsig_par[i][ii]);
	//	      cout<<"sigma trk1= "<<sigma[jj][j][dspn1]<<endl;
	//        cout<<"sigma_t trk1= "<<sigma_t[jj][j][dspn1]<<endl;
	//        cout<<"sigma trk2= "<<sigma[jj][j][dspn2]<<endl;
	//        cout<<"sigma_t trk2= "<<sigma_t[jj][j][dspn2]<<endl;
	
			//
			// invert the bad
			//
			if(calibdata1->DSPbad_par[i][ii]==0) 
				bad[jj][j][dspn1]=1;
			else if(calibdata1->DSPbad_par[i][ii]==1)
				bad[jj][j][dspn1]=0;
			if(calibdata2->DSPbad_par[i][ii]==0)
				bad[jj][j][dspn2]=1;
			else if(calibdata2->DSPbad_par[i][ii]==1)
				bad[jj][j][dspn2]=0;
		};
	};
	
	tr1->Delete();
	tr2->Delete();
};

/**
 * Method to fill the tracker calibration-parameter struct from on-line calibrations
 */
void cTrkCalib::FillFCalibFrom(TFile* f0, Int_t ev_reg1, Int_t ev_reg2){

    TTree *tr1 = (TTree*)f0->Get("CalibTrk1");  
    TTree *tr2 = (TTree*)f0->Get("CalibTrk2"); 

    CalibTrk1Event *calibdata1 = 0;
    CalibTrk2Event *calibdata2 = 0;
    tr1->SetBranchAddress("CalibTrk1",&calibdata1);
    tr2->SetBranchAddress("CalibTrk2",&calibdata2);
    tr1->GetEntry(ev_reg1);
    tr2->GetEntry(ev_reg2); 
    Int_t dspn1(0),dspn2(0);
	
    for(Int_t i=0;i<6;i++){
	dspn1=calibdata1->DSPnumber[i]-1;
	dspn2=calibdata2->DSPnumber[i]-1;
	/*     cout<<"dspn1= "<<dspn1<<"   dspn2= "<<dspn2<<endl; */
	for(Int_t ii=0;ii<3072;ii++){
	    Int_t j=(ii/128);
	    Int_t jj=ii-j*128; 
	    pedestal[jj][j][dspn1]=calibdata1->DSPped_par[i][ii];
	    pedestal[jj][j][dspn2]=calibdata2->DSPped_par[i][ii];
	    sigma[jj][j][dspn1]=calibdata1->DSPsig_par[i][ii];
	    sigma[jj][j][dspn2]=calibdata2->DSPsig_par[i][ii];
	//	      cout<<"sigma trk1= "<<sigma[jj][j][dspn1]<<endl;
	//        cout<<"sigma_t trk1= "<<sigma_t[jj][j][dspn1]<<endl;
	//        cout<<"sigma trk2= "<<sigma[jj][j][dspn2]<<endl;
	//        cout<<"sigma_t trk2= "<<sigma_t[jj][j][dspn2]<<endl;
	
	    //
			// invert the bad
	    //
	    if(calibdata1->DSPbad_par[i][ii]==0)
		bad[jj][j][dspn1]=1;
	    else if(calibdata1->DSPbad_par[i][ii]==1)
		bad[jj][j][dspn1]=0;
	    if(calibdata2->DSPbad_par[i][ii]==0)
		bad[jj][j][dspn2]=1;
	    else if(calibdata2->DSPbad_par[i][ii]==1)
		bad[jj][j][dspn2]=0;
	};
    };
	
    tr1->Delete();
    tr2->Delete();
};
/**
 * Method to fill the tracker calibration-parameter struct from on-line calibrations
 */
void cTrkCalib::FillTCalibFrom(TFile* f0, Int_t ev_reg1, Int_t ev_reg2){

    TTree *tr1 = (TTree*)f0->Get("CalibTrk1");  
    TTree *tr2 = (TTree*)f0->Get("CalibTrk2"); 

    CalibTrk1Event *calibdata1 = 0;
    CalibTrk2Event *calibdata2 = 0;
    tr1->SetBranchAddress("CalibTrk1",&calibdata1);
    tr2->SetBranchAddress("CalibTrk2",&calibdata2);
    tr1->GetEntry(ev_reg1);
    tr2->GetEntry(ev_reg2); 
    Int_t dspn1(0),dspn2(0);
	
    for(Int_t i=0;i<6;i++){
	dspn1=calibdata1->DSPnumber[i]-1;
	dspn2=calibdata2->DSPnumber[i]-1;
	/*     cout<<"dspn1= "<<dspn1<<"   dspn2= "<<dspn2<<endl; */
	for(Int_t ii=0;ii<3072;ii++){
	    Int_t j=(ii/128);
	    Int_t jj=ii-j*128; 
	    pedestal_t[jj][j][dspn1]=aint(calibdata1->DSPped_par[i][ii]);
	    pedestal_t[jj][j][dspn2]=aint(calibdata2->DSPped_par[i][ii]);
	    sigma_t[jj][j][dspn1]=anint(calibdata1->DSPsig_par[i][ii]);
	    sigma_t[jj][j][dspn2]=anint(calibdata2->DSPsig_par[i][ii]);	
	};
    };
	
    tr1->Delete();
    tr2->Delete();
};
/**
 * Method to fill the tracker calibration-parameter struct from default calibration
 */
void cTrkCalib::FillTCalibFrom(TString path){
    
    path_.FillWith(path);
    fillpedsigfromdefault_();
    if(path_.error) throw -216;

};

