/**
 * \file TrkLevel1.cpp
 * \author Elena Vannuccini
 */
#include <TrkLevel1.h>
#include <iostream>
using namespace std;
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::TrkCluster(){
	
	view     = 0;
	ladder   = 0;
	maxs     = 0;
	mult     = 0;
	sgnl     = 0;
	whichtrk = -1;
	CLlength = 0;
	clsignal = 0; 
	clsigma  = 0; 
	cladc    = 0; 
	clbad    = 0; 

};
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::~TrkCluster(){
	
	delete [] clsignal; 
	delete [] clsigma; 
	delete [] cladc; 
	delete [] clbad; 
};
//--------------------------------------
//
//
//--------------------------------------
TrkCluster::TrkCluster(const TrkCluster& t){
	
	view     = t.view;
	ladder   = t.ladder;
	maxs     = t.maxs;
	mult     = t.mult;
	sgnl     = t.sgnl;
	whichtrk = t.whichtrk;
	
	CLlength = t.CLlength;	
	clsignal = new Float_t[CLlength];
	clsigma  = new Float_t[CLlength];
	cladc    = new Int_t[CLlength];
	clbad    = new Bool_t[CLlength];
	for(Int_t i=0; i<CLlength;i++){
		clsignal[i] = t.clsignal[i]; 
		clsigma[i]  = t.clsigma[i]; 
		cladc[i]    = t.cladc[i]; 
		clbad[i]    = t.clbad[i]; 
	};

};
//--------------------------------------
//
//
//--------------------------------------
void TrkCluster::Dump(){

	cout << "----- Cluster" << endl;
	cout << "View "<<view << " - Ladder "<<ladder<<endl;
	cout << "(Track ID "<<whichtrk<<")"<<endl;
	cout << "Position of maximun "<<maxs<<endl;
	cout << "Multiplicity        "<<mult<<endl;
	cout << "Tot signal          "<<sgnl<< " (ADC channels)";
	cout <<endl<< "Strip signals       ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<clsignal[i];
	cout <<endl<< "Strip sigmas        ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<clsigma[i];
	cout <<endl<< "Strip ADC           ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<cladc[i];
	cout <<endl<< "Strip BAD           ";
	for(Int_t i =0; i<CLlength; i++)cout << " " <<clbad[i];
	cout << endl;
	
}
//--------------------------------------
//
//
//--------------------------------------
TrkLevel1::TrkLevel1(){
    
	good1 = -1;
	
	Cluster = new TClonesArray("TrkCluster");
	
	for(Int_t i=0; i<12 ; i++){
//		crc[i] = -1;
		for(Int_t j=0; j<24 ; j++){
			cnev[j][i]=0;
			cnnev[j][i]=0;
		};
		fshower[i]=0;
	};
}
//--------------------------------------
//
//
//--------------------------------------
void TrkLevel1::Dump(){
    
	TClonesArray &t  = *Cluster;
    
	for(int i=0; i<this->nclstr(); i++)     ((TrkCluster *)t[i])->Dump();

}
//--------------------------------------
//
//
//--------------------------------------
/**
 * Fills a TrkLevel1 object with values from a struct cTrkLevel1 (to get data from F77 common).
 */
void TrkLevel1::SetFromLevel1Struct(cTrkLevel1 *l1){

	//  *** CLUSTER ***
	TrkCluster* t_cl = new TrkCluster();
	TClonesArray &t = *Cluster;
	for(int i=0; i<l1->nclstr1; i++){
		
		t_cl->view     = l1->view[i];
		t_cl->ladder   = l1->ladder[i];
		t_cl->maxs     = l1->maxs[i];
		t_cl->mult     = l1->mult[i];
		t_cl->sgnl     = l1->dedx[i];
		t_cl->whichtrk = l1->whichtrack[i]-1;
		
		Int_t from = l1->indstart[i] -1;
		Int_t to   = l1->totCLlength ;
		if(i != l1->nclstr1-1)to   = l1->indstart[i+1] -1 ;
		t_cl->CLlength = to - from ;
		
		t_cl->clsignal = new Float_t[t_cl->CLlength];
		t_cl->clsigma  = new Float_t[t_cl->CLlength];
		t_cl->cladc    = new Int_t[t_cl->CLlength];
		t_cl->clbad    = new Bool_t[t_cl->CLlength];
		Int_t index = 0;
		for(Int_t is = from; is < to; is++ ){
			t_cl->clsignal[index] = (Float_t) l1->clsignal[is];
			t_cl->clsigma[index]  = (Float_t) l1->clsigma[is];
			t_cl->cladc[index]    = (Int_t)   l1->cladc[is];
			t_cl->clbad[index]    = (Bool_t)  l1->clbad[is];
			index++;
		};
				
		new(t[i]) TrkCluster(*t_cl);
	};
	
	delete t_cl;

	//  general variables

	good1 = l1->good1;
	for(Int_t i=0; i<12 ; i++){
//		crc[i] = l1->crc[i];
		for(Int_t j=0; j<24 ; j++){
			cnev[j][i]     = l1->cnev[j][i];
			cnnev[j][i] = l1->cnnev[j][i];
		};
		fshower[i] = l1->fshower[i];
	};
	
}
/**
 * Fills a struct cTrkLevel1 with values from a TrkLevel1 object (to put data into a F77 common).
 */

void TrkLevel1::GetLevel1Struct(cTrkLevel1 *l1) const {
  
	// ********* completare ********* //
	// ********* completare ********* //
	// ********* completare ********* //
	// ********* completare ********* //
	// ********* completare ********* //
	// ********* completare ********* //
//  general variables
	l1->good1 = good1;
	for(Int_t i=0; i<12 ; i++){
//		l1->crc[i] = crc[i];
		for(Int_t j=0; j<24 ; j++){
			l1->cnev[j][i]     = cnev[j][i];
			l1->cnnev[j][i] = cnnev[j][i];
		};
		l1->fshower[i] = fshower[i];
	};
	
//  *** CLUSTERS ***
    l1->nclstr1 =  Cluster->GetEntries();
	for(Int_t i=0;i<l1->nclstr1;i++){

		l1->view[i]     = ((TrkCluster *)Cluster->At(i))->view;
		l1->ladder[i]   = ((TrkCluster *)Cluster->At(i))->ladder;
		l1->maxs[i]     = ((TrkCluster *)Cluster->At(i))->maxs;
		l1->mult[i]     = ((TrkCluster *)Cluster->At(i))->mult;
		l1->dedx[i]     = ((TrkCluster *)Cluster->At(i))->sgnl; 
		
	}
	
	// ********* completare ********* //

}
//--------------------------------------
//
//
//--------------------------------------
void TrkLevel1::Clear(){
	
	good1    = -1;
	for(Int_t i=0; i<12 ; i++){
//		crc[i] = -1;
		for(Int_t j=0; j<24 ; j++){
			cnev[j][i]     = 0;
			cnnev[j][i] = 0;
		};
		fshower[i] = 0;
	};
//	totCLlength = 0;
	Cluster->Clear();

}
//--------------------------------------
//
//
//--------------------------------------
TrkCluster *TrkLevel1::GetCluster(int is){

	if(is >= this->nclstr()){
		cout << "** TrkLevel1::GetCluster(int) ** Cluster "<< is << " does not exits! " << endl; 
		cout << "( Stored clusters nclstr() = "<< this->nclstr()<<" )" << endl;
		return 0;
	}
	TClonesArray &t = *(Cluster);
	TrkCluster *cluster = (TrkCluster*)t[is];
	return cluster;
}

// //--------------------------------------
// //
// //
// //--------------------------------------
// TrkTrackRef::TrkTrackRef(){
// 	for(int ip=0;ip<6;ip++){
// 		clx[ip]  = 0;
// 		cly[ip]  = 0;
// 	};
// };
// //--------------------------------------
// //
// //
// //--------------------------------------
// TrkTrackRef::TrkTrackRef(const TrkTrackRef& t){
// 	for(int ip=0;ip<6;ip++){
// 		clx[ip]  = t.clx[ip];
// 		cly[ip]  = t.cly[ip];
// 	};
// };
// //--------------------------------------
// //
// //
// //--------------------------------------
// void TrkTrackRef::Clear(){
// 	for(int ip=0;ip<6;ip++){
// 		clx[ip]  = 0;
// 		cly[ip]  = 0;
// 	};
// };
// //--------------------------------------
// //
// //
// //--------------------------------------
// TrkLevel2Ref::TrkLevel2Ref(){
// 	Track    = new TClonesArray("TrkTrackRef");
// 	SingletX = new TClonesArray("TRef");
// 	SingletY = new TClonesArray("TRef");
// };
// //--------------------------------------
// //
// //
// //--------------------------------------
// void TrkLevel2Ref::SetFromLevel2Struct(cTrkLevel2 *l2){
// 	
// 	TrkTrackRef*   t_track   = new TrkTrackRef();
// 	TRef t_singlet = 0;
// 	
// 	TClonesArray &t = *Track;
// 	for(int i=0; i<l2->ntrk; i++){
// 		for(int ip=0;ip<6;ip++){
// 			t_track->clx[ip]  = 0;//<<<puntatore al cluster
// 			t_track->cly[ip]  = 0;//<<<puntatore al cluster
// 		};
// 		new(t[i]) TrkTrackRef(*t_track);
// 		t_track->Clear();
// 	};
// //  *** SINGLETS ***
// 	TClonesArray &sx = *SingletX;
// 	for(int i=0; i<l2->nclsx; i++){
// 		t_singlet = 0;//<<<puntatore al cluster
// 		new(sx[i]) TRef(t_singlet);
// 	}
// 	TClonesArray &sy = *SingletY;
// 	for(int i=0; i<l2->nclsy; i++){
// 		t_singlet = 0;//<<<puntatore al cluster
// 		new(sy[i]) TRef(t_singlet);
// 	};
// 	
// 	delete t_track;
// }
// //--------------------------------------
// //
// //
// //--------------------------------------
// void TrkLevel2Ref::Clear(){
// 	Track->Clear();
// 	SingletX->Clear();
// 	SingletY->Clear();
// }

ClassImp(TrkLevel1);
ClassImp(TrkCluster);
// ClassImp(TrkTrackRef);
// ClassImp(TrkLevel2Ref);
