#include <TObject.h>
#include <TrigLevel2.h>
ClassImp(TrigLevel2);

TrigLevel2::TrigLevel2() {    

  evcount = 0;
  for (Int_t kk=0; kk<3;kk++){
    pmtpl[kk] = 0;
    patternbusy[kk] = 0;
  } 
  
  for (Int_t kk=0; kk<6;kk++){
    trigrate[kk] = 0;
    patterntrig[kk] = 0;
  } 
  
  for (Int_t kk=0; kk<2;kk++){
    dltime[kk] = 0;
    s4calcount[kk] = 0;
  }

  for (Int_t kk=0; kk<24;kk++){
    pmtcount1[kk] = 0;
    pmtcount2[kk] = 0;
  }
  
  trigconf = 0;
}

void TrigLevel2::Clear(){

  evcount = 0;
  for (Int_t kk=0; kk<3;kk++){
    pmtpl[kk] = 0;
    patternbusy[kk] = 0;
  } 
  
  for (Int_t kk=0; kk<6;kk++){
    trigrate[kk] = 0;
    patterntrig[kk] = 0;
  } 
  
  for (Int_t kk=0; kk<2;kk++){
    dltime[kk] = 0;
    s4calcount[kk] = 0;
  }

  for (Int_t kk=0; kk<24;kk++){
    pmtcount1[kk] = 0;
    pmtcount2[kk] = 0;
  }
  
  trigconf = 0;
}

/**
 * Fills a struct cTrigLevel2 with values from a TrigLevel2 object (to put data into a F77 common).
 */
void TrigLevel2::GetLevel2Struct(cTrigLevel2 *l2) const{

  l2->evcount  = evcount;
  l2->trigconf = trigconf;
  
  for(int i=0;i<2;i++){
    l2->s4calcount[i] = s4calcount[i];
    l2->dltime[i]     = dltime[i];
  }
  
  for(int i=0;i<3;i++){
    l2->pmtpl[i]       = pmtpl[i];
    l2->patternbusy[i] = patternbusy[i];
  }
  
  for(int i=0;i<6;i++){
    l2->trigrate[i]    = trigrate[i];
    l2->patterntrig[i] = patterntrig[i];
  }
  
  for(int i=0;i<24;i++){
    l2->pmtcount1[i] = pmtcount1[i];
    l2->pmtcount2[i] = pmtcount2[i];
  }
}

void TrigLevel2::SetFromLevel2Struct(cTrigLevel2 *l2){

  evcount  = l2->evcount;
  trigconf = l2->trigconf;
  
  for(int i=0;i<2;i++){
    s4calcount[i] = l2->s4calcount[i];
    dltime[i]     = l2->dltime[i];
  }
  
  for(int i=0;i<3;i++){
    pmtpl[i]       = l2->pmtpl[i];
    patternbusy[i] = l2->patternbusy[i];
  }
  
  for(int i=0;i<6;i++){
    trigrate[i]    = l2->trigrate[i];
    patterntrig[i] = l2->patterntrig[i];
  }
  
  for(int i=0;i<24;i++){
    pmtcount1[i] = l2->pmtcount1[i];
    pmtcount2[i] = l2->pmtcount2[i];
  }
}
