/**
 * \file TrkProcess.cpp
 * \author Elena Vannuccini
 */
#include <TrkProcess.h>
#include <iostream>
using namespace std;

TrkProcess::TrkProcess(){
    
    idrun = 0;
    DEBUG = false;
    get1 = 0;
    get2 = 1;
    standalone = false;
    frame2 = "root";
    frame1 = "hbook";
    outdir =  gSystem->WorkingDirectory(); 
    pfolder = "/TrackerFolder"; 
    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 =false;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 =false;

    file1 = "";
    file2 = "";
    
};
	
TrkProcess::TrkProcess(ULong64_t run, TFile *f2){
	
    idrun = run;
    DEBUG = false;
    get1 = 0;
    get2 = 1;
    standalone = false;
    frame2 = "root";
    frame1 = "hbook";
    ifroot1 = false;
    ifroot2 = true;
    file1 = "";
    if(f2->IsOpen()){
	file2  = f2->GetPath();
//	TString temp = file2(0,file2.Last(':'));
//	outdir = temp(0,temp.Last('/'));
	outdir = gSystem->DirName(gSystem->DirName(file2));
// check if the indicated output directory exists
	FileStat_t t;
	if( gSystem->GetPathInfo(outdir.Data(),t) )throw -12;
    }else{ 
	file2 = "";    
	outdir =  gSystem->WorkingDirectory();
    }; 
    pfolder = "/TrackerFolder"; 

    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 =false;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 =false;

	
};
	
int TrkProcess::HandleCustomPar(int ncustom, char *vcustom[]){

    for (int i=0; i< ncustom; i++){
		
	// -----------------------------------------------------//
	if (!strcmp(vcustom[i], "-processFolder")){
	    if (++i >= ncustom) throw -3;
	    pfolder = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--get1")){
	    get1 = 1;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--dontget2")){
	    get2 = 0;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "--standalone") || !strcmp(vcustom[i], "-s")){
	    standalone = true;
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-processFile1")){
	    if (++i >= ncustom) throw -3;
	    get1 = 1;
	    file1 = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-frame1")){
	    if (++i >= ncustom)throw -3;
	    get1 = 1;
	    frame1 = vcustom[i];						
	    continue;
	}  
	// -----------------------------------------------------//    
	if (!strcmp(vcustom[i], "-frame2")){
	    if (++i >= ncustom)throw -3;
	    get2 = 1;
	    frame2 = vcustom[i];
	    continue;
	}  
	// -----------------------------------------------------//    
	else if (!strcmp(vcustom[i], "--verbose") || !strcmp(vcustom[i], "-v")){
	    DEBUG = true;
	    continue;
	}  
    }	
    
    if      (!frame2.CompareTo("root", TString::kIgnoreCase))  ifroot2 = true;		
    else if (!frame2.CompareTo("hbook", TString::kIgnoreCase)) ifroot2 =false;
    else    throw -201;
    
    if      (!frame1.CompareTo("root", TString::kIgnoreCase))  ifroot1 = true;		
    else if (!frame1.CompareTo("hbook", TString::kIgnoreCase)) ifroot1 =false;
    else    throw -201;
    
    if(get1){
	TString filety;
	if      ( ifroot1)  filety=".root";		
	else if (!ifroot1)  filety=".rz";
	else    throw -200;
// 	file1 = outdir + "/"+ pfolder + "/" + file2(file2.Last('/')+1,file2.Last('.')) + ".Level1" + filety;
// 	cout << p->file1 << endl;
// 	TString path = gSystem->DirName(p->file1);
// 	FileStat_t t;
// 	// check if processFolder directory exists, and possibly create it 
// 	if( gSystem->GetPathInfo(path.Data(),t) ) {
// 	    if( gSystem->MakeDirectory(path.Data()) == -1)throw -13;
// 	};
// 	// if it does, open/create teh putput file

    };


    return 0;
};
		
void TrkProcess::Dump(){

    cout <<endl<< "Tracker process parameters: "<< endl;
    cout << " idRun           " << idrun << endl;
    cout << " get1            " << get1 << endl;
    cout << " get2            " << get2 << endl;
    cout << " frame1          " << frame1 << endl;
    cout << " frame2          " << frame2 << endl;
    cout << " file1           " << file1 << endl;
    cout << " file2           " << file2 << endl;
    cout << " outdir          " << outdir << endl;
    cout << " process folder  " << pfolder << endl;    
    cout << " standalone mode " << standalone << endl;
    cout << " debug mode      " << DEBUG << endl<< endl;
    
}
